#!/usr/bin/env python
"""
Ping - przeznaczona na Raspberry Pi
jednoosobowa gra w tenisa stoowego z zapisem wynikw
"""
import time                     # Na potrzeby dodawania opnie
import os, pygame, sys
import random

pygame.init()                   # Inicjowanie interfejsu graficznego
pygame.mixer.quit()
pygame.mixer.init(frequency=22050, size=-16, channels=2, buffer=512)
bounceSound = pygame.mixer.Sound("sounds/bounce.ogg")
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Ping - wersja jednoosobowa")
screenWidth = 500
screenHeight =300
screen = pygame.display.set_mode([screenWidth,screenHeight],0,32)
background = pygame.Surface((screenWidth,screenHeight))
textSize = 36
scoreSurface = pygame.Surface((textSize,textSize))
font = pygame.font.Font(None, textSize)

# Definiowanie kolorw interfejsu graficznego
cBackground =(255,255,255)
cBall = (0,0,0)
background.fill(cBackground) # Okrelanie koloru ta
cText = (0,0,0)
box = [screenWidth-10,screenHeight-10]
deltaChoice = [ [15,1], [14,1], [13,1], [12,1], [11,1], [10,1], [15,2], [14,2], [13,2], [12,2], [11,2], [10,2] ]
maxDelta = 11
delta = deltaChoice[random.randint(0,maxDelta)]
hw = screenWidth / 2
hh = screenHeight /2
ballPosition = [-hw,hh] # Pozycja piki na ekranie
batMargin = 30 # Odlego rakietki od krawdzi
batHeight = 24
batThick = 6
batInc = 20 # Szybko ruchu rakietki
batX = [batMargin, screenWidth - batMargin]
batY = [hh, hh] # Pocztkowa pozycja rakietki
limit = [0, 0, 0, 0, 0, 0] # Granice krawdzi i rakietki
ballRad = 8 # Wielko piki
rally = True
pause = True
score = 0
best = 0  # Rekord
balls = 3 # Liczba piek w rozgrywce
ballsLeft = balls

def main():
   global ballPosition, rally, balls, pause, score, best   
   updateBox(0,0) # Ustawianie granic krawdzi
   updateScore()
   screen.blit(background,[0,0])
   while True :
     ballsLeft = balls
     if score > best:
        best = score
     score = 0
     updateScore()
     while ballsLeft > 0:
      ballPosition = waitForServe(ballPosition)
      while rally :
            checkForEvent()
            time.sleep(0.05)
            drawScreen(ballPosition)
            ballPosition = moveBall(ballPosition)
      ballsLeft -= 1
     print "Wcinij spacj, aby otrzyma dodatkowe piki (",balls,")"
     pause = True
     while pause :
       checkForEvent()
     
      
def waitForServe(p) :
     global batY, rally, delta
     computerBatDelta = 2
     serveTime = time.time() + 2.0 # Automatyczny serwis
     while time.time() < serveTime :
            checkForEvent()
            drawScreen(p)
            batY[0] += computerBatDelta # Przesuwanie rakietki w gr i w d w trakcie oczekiwania na odbicie
            if batY[0] > limit[3] or batY[0] < limit[2]:
               computerBatDelta = -computerBatDelta
     p[0] = batX[0]
     p[1] = batY[0]
     delta = deltaChoice[random.randint(0,maxDelta)]
     rally = True
     return p

def moveBall(p):
    global delta, batY, rally, score, batThick
    p[0] += delta[0]
    p[1] += delta[1]
    # Wykrywanie zderze
    if p[1] <= limit[2] : # Wykrywanie odbicia od gry
       bounceSound.play()
       delta[1] = - delta[1]
       p[1] = limit[2]
    elif p[1] >= limit[3] : # Wykrywanie odbicia od dou
       bounceSound.play()
       delta[1] = - delta[1] 
       p[1] = limit[3]
    elif p[0] <= limit[0] : # Wykrywanie nietrafienia piki przez gracza 1
       p[0] = limit[0]
       rally = False
       print " nietrafiona pika"
    elif p[0] >= limit[1] : # Wykrywanie nietrafienia piki przez gracza 2
       p[0] = limit[1]
       rally = False
       print " nietrafiona pika"
    # Wykrywanie uderze w lew rakietk
    elif p[0] <= limit[4] and p[1] >= batY[0] - ballRad and p[1] <= batY[0] + ballRad + batHeight:
       bounceSound.play()
       p[0] = limit[4]
       delta[0] = random.randint(5,15)
       if random.randint(1,4) > 2 : # Losowa zmiana szybkoci ruchu na osi y
          delta[1] = 16 - delta[0]
       else :
          delta[1] = -(16 - delta[0])
    # Wykrywanie uderze w praw rakietk     
    elif p[0] >= limit[5] and p[1] >= batY[1] - ballRad and p[1] <= batY[1] + ballRad + batHeight:
       bounceSound.play()
       delta[0] = - delta[0]
       p[0] = limit[5]
       score+= 1
       updateScore()
    batY[0] = p[1] - ballRad # Rakietka automatycznie poda za pik
    #batY[1] = p[1]- ballRad # Tymczasowy test gracza sterowanego przez komputer
    return p
   
def updateScore():
    global score, best, scoreRect, scoreSurface
    scoreSurface = font.render(str(best)+" : "+str(score), True, cText, cBackground)
    scoreRect = scoreSurface.get_rect()
    scoreRect.centerx = hw
    scoreRect.centery = 24
    
def drawScreen(p) : # Rysowanie na ekranie
    global rally
    screen.blit(background,[0,0]) # Ustawianie koloru ta
    pygame.draw.rect(screen,(255,0,0), (hw - (box[0]/2),hh - (box[1]/2),box[0],box[1]), 4)
    pygame.draw.line(screen,(0,255,0), (batX[0], batY[0]),(batX[0], batY[0]+batHeight),batThick)
    pygame.draw.line(screen,(0,255,0), (batX[1], batY[1]),(batX[1], batY[1]+batHeight),batThick)
    screen.blit(scoreSurface, scoreRect)
    if rally :
        pygame.draw.circle(screen,cBall, (p[0], p[1]),ballRad, 2)
    pygame.display.update()

def updateBox(d,amount):
    global box, limit
    box[d] += amount    
    limit[0] = hw - (box[0]/2) +ballRad # Lewa granica
    limit[1] = hw + (box[0]/2) -ballRad # Prawa granica
    limit[2] = hh - (box[1]/2) + ballRad # Grna granica
    limit[3] = (hh + (box[1]/2))-ballRad # Dolna granica
    limit[4] = batX[0] + ballRad + batThick/2 # Wsprzdna x granicy dla piki leccej od lewej do prawej
    limit[5] = batX[1] - ballRad - batThick/2  # Wsprzdna x granicy dla piki leccej od prawej do lewej 
         
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu - prosz czeka")
    pygame.quit() # Usuwanie obiektu pygame
    sys.exit()
    
def checkForEvent(): # Sprawdzanie, czy naley zamkn program
    global batY, rally, pause
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    if event.type == pygame.KEYDOWN :            
       if event.key == pygame.K_ESCAPE :
           terminate()
       if event.key == pygame.K_DOWN : # Zwikszanie lub zmniejszanie okna
            updateBox(1,-2)
       if event.key == pygame.K_UP :
            updateBox(1,2)
       if event.key == pygame.K_LEFT :
            updateBox(0,-2)
       if event.key == pygame.K_RIGHT :
            updateBox(0,2)
       if event.key == pygame.K_s :
            rally = True
       if event.key == pygame.K_SPACE :
            pause = False
       if event.key == pygame.K_PAGEDOWN :
          if batY[1] < screenHeight - batInc :
            batY[1] += batInc
       if event.key == pygame.K_PAGEUP :
          if batY[1] > batInc :
            batY[1] -= batInc
     
            
if __name__ == '__main__':
    main()   
